<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Payments</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('AdminDash')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Payments</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>


            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="callRecordsTable" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th data-sortable="true">ID</th>
                                    <th data-sortable="true">Date</th>
                                    <th data-sortable="false">Method</th>
                                    <th data-sortable="false">Number</th>
                                    <th data-sortable="false">Transaction ID</th>
                                    <th data-sortable="false">Amount</th>
                                    <th data-sortable="true">Status</th>
                                </tr>
                                </thead>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="text-center">
                                        
                                        <td><?php echo e($item->id); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d.m.Y')); ?></td>
                                        <td><?php echo e($item->method); ?></td>
                                        <td><?php echo e($item->number); ?></td>
                                        <td><?php echo e($item->trxid); ?></td>
                                        <td><?php echo e($item->amount); ?></td>
                                        <td>
                                            <?php if($item->status == "Success"): ?>
                                                <span class="badge badge-success">Success</span>
                                            <?php elseif($item->status == "Pending"): ?>
                                                <span class="badge badge-warning">Pending</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Failed</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/appeejob/public_html/resources/views/dashboard/paymentsdata.blade.php ENDPATH**/ ?>