

<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>UNIQUE EARNING Updating...</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
<style>
/* বর্তমান ব্যালেন্স বক্স */
.balance-box {
  background: linear-gradient(135deg, #d0eaff, #e0ffe0);
  border-radius: 14px;
  padding: 20px 15px;
  text-align: center;
  margin: 20px auto 25px auto;
  max-width: 480px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.06);
  transition: all 0.3s ease;
}

.balance-box:hover {
  transform: translateY(-3px);
  box-shadow: 0 6px 15px rgba(0, 0, 0, 0.12);
}

.balance-icon {
  height: 40px;
  margin-bottom: 8px;
}

.balance-title {
  font-size: 18px;
  font-weight: 700;
  color: #ff9100;
  margin-bottom: 5px;
  letter-spacing: 0.5px;
}

.balance-amount {
  font-size: 24px;
  font-weight: 800;
  color: #007bff;
}

/* মেনু লিস্ট */
.menu-list {
  display: flex;
  flex-direction: column;
  gap: 12px;
  padding: 0 15px;
  max-width: 480px;
  margin: 0 auto;
}

/* মেনু আইটেম */
.menu-item {
  background: #ffffff;
  border-radius: 12px;
  padding: 12px 15px;
  text-decoration: none;
  color: #333;
  display: flex;
  justify-content: space-between;
  align-items: center;
  box-shadow: 0px 2px 6px rgba(0, 0, 0, 0.05);
  transition: all 0.3s ease;
}

.menu-item:hover {
  background: #e3f2fd;
  transform: scale(1.02);
}

.menu-left {
  display: flex;
  align-items: center;
  gap: 10px;
}

.menu-icon {
  height: 26px;
}

.arrow-icon {
  height: 18px;
  opacity: 0.6;
}

/* মোবাইল রেস্পনসিভ */
@media (max-width: 576px) {
  .balance-box {
    margin: 15px 10px 20px 10px;
    padding: 18px 12px;
  }
  .balance-title {
    font-size: 17px;
  }
  .balance-amount {
    font-size: 22px;
  }
  .menu-list {
    padding: 0 10px;
  }
  .menu-item {
    padding: 10px 14px;
  }
}
</style>
  <style>
    body {
      font-family: 'Arial', sans-serif;
      background: #f8f9fa;
      margin: 0;
      padding: 0;
    }

    /* হেডার */
    .header {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      padding: 15px 20px 60px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: white;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
      border-bottom-left-radius: 80px 30px;
      border-bottom-right-radius: 80px 30px;
      position: relative;
      z-index: 1001;
    }
    .header-left {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .header-left i, .header-right i {
      font-size: 26px;
      cursor: pointer;
    }
    .header-left span {
      font-size: 22px;
      font-weight: bold;
    }
    
    /* সাইডবার */
.sidebar {
  position: fixed;
  top: 0;
  left: -260px;
  height: 100%;
  width: 260px;
  background: linear-gradient(180deg, #43a047, #2e7d32);
  transition: all 0.3s ease;
  z-index: 9999;
  overflow-y: auto;
  padding-top: 20px;
  box-shadow: 2px 0 8px rgba(0, 0, 0, 0.2);
}

/* সাইডবার লিঙ্ক */
.sidebar a {
  display: flex;
  align-items: center;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  color: white;
  text-decoration: none;
  font-size: 18px;
  transition: background 0.3s ease;
  margin: 0;
  line-height: 1;
}

.sidebar a i {
  margin-right: 10px;
}

.sidebar a:hover {
  background: #16a085;
}

.sidebar a .link-text {
  flex-grow: 1;
  margin-left: 10px;
  text-align: left;
}

.sidebar a .arrow {
  margin-left: auto;
}

/* সাইডবার হেডার */
.sidebar-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px 15px; /* হেডারের প্যাডিং কমানো হলো */
  background: linear-gradient(90deg, #4CAF50, #2ecc71);
}

.sidebar-header h2 {
  color: white;
  font-size: 20px;
  margin: 0;
}

/* সাইডবার ক্লোজ বাটন */
.sidebar .close-btn {
  font-size: 30px;
  color: white;
  cursor: pointer;
}

/* সাইডবার লিঙ্কের তালিকা */
.sidebar-links {
  list-style: none;
  padding: 0;
  margin: 0;
}

.sidebar-links li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  border-bottom: 1px solid #fff; /* সাদা দাগ */
}

.sidebar-links li a {
  display: flex;
  align-items: center;
  color: white;
  text-decoration: none;
  font-size: 16px;
  flex-grow: 1;
}

.sidebar-links li a i {
  margin-right: 8px;
  font-size: 18px;
}

/* রেসপন্সিভ */
@media (max-width: 768px) {
  .sidebar {
    width: 230px;
  }
}
.sidebar-user-info {
  padding: 20px 10px;
  border-bottom: 1px solid #ffffff;
  text-align: center;
}

.sidebar-user-info .profile-pic img {
  height: 80px;
  width: 80px;
  object-fit: cover;
  border-radius: 50%;
  border: 2px solid white;
  margin-bottom: 10px;
}

.sidebar-user-info .decorative-line {
  height: 20px;
  margin: 0 auto 10px;
  display: block;
}

.sidebar-user-info .user-name {
  margin: 5px 0;
  font-size: 18px;
  color: #ffffff;
  font-weight: bold;
}

.sidebar-user-info .user-data {
  margin-top: 8px;
  color: #ffffff;
  font-size: 14px;
}

.sidebar-user-info .user-data p {
  margin: 4px 0;
}

.sidebar-user-info .account-status {
  margin-top: 8px;
  padding: 6px 20px;
  background: linear-gradient(135deg, #6a11cb, #2575fc);
  border-radius: 20px;
  display: inline-block;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  font-weight: bold;
}


.user-info {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-top: 20px;
}

.user-info img {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  border: 3px solid #ffffff;
  object-fit: cover; /* ইমেজকে সুন্দরভাবে কাটবে */
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* হালকা ছায়া */
}

.user-info h3 {
  margin: 10px 0 5px;
  font-size: 20px;
  color: #ffffff;
  font-weight: 600;
}

.user-info p {
  font-size: 14px;
  color: #ecf0f1;
  margin: 2px 0;
}
    
    /* ফুটার */
    .footer {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      display: flex;
      justify-content: space-around;
      align-items: center;
      padding: 10px 0;
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      z-index: 999;
      height: 65px;
      box-shadow: 0 -2px 8px rgba(0,0,0,0.1);
    }
    .footer-item {
      color: white;
      text-decoration: none;
      font-size: 13px;
      display: flex;
      flex-direction: column;
      align-items: center;
      flex: 1;
      position: relative;
    }
    .footer-item i {
      font-size: 22px;
      margin-bottom: 3px;
    }
    .footer-item:not(:last-child)::after {
      content: "";
      position: absolute;
      right: 0;
      top: 10px;
      bottom: 10px;
      width: 1px;
      background: rgba(255,255,255,0.5);
    }

    
</style>
</head>

<body>



<!-- সাইডবারের কোড -->
<div class="sidebar" id="sidebar">
  <div class="sidebar-header">
    <h2>মেনু</h2>
    <button class="close-sidebar" onclick="toggleSidebar()">×</button>
  </div>
 
 
<div class="sidebar-user-info text-center">
    <div class="profile-pic">
        <img src="<?php echo e(asset('uploads/profile_images/' . Auth::user()->profile_image)); ?>" alt="User">
    </div>
    
    
    <h5 class="user-name"><?php echo e(auth()->user()->fname); ?> <?php echo e(auth()->user()->lname); ?></h5>
    
    <div class="user-data">
        <p class="m-0">Refer ID: <?php echo e(auth()->user()->ref_code); ?></p>
        <p class="m-0">Joined: <?php echo e(auth()->user()->created_at->format('M D Y')); ?></p>
        
        <div class="account-status">
            একাউন্ট সেটিংস : 
            <span style="color: #ff4d4d">
                🎉
            </span>
        </div>
    </div>
</div>
    
  <ul class="sidebar-links">
  <li>
    <a href="/dashboard">
      <i class="fas fa-home"></i> হোম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/profile">
      <i class="fas fa-user"></i> প্রোফাইল
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/notice">
      <i class="fas fa-coins""></i>আমার ইনকাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="<?php echo e(app('telegram_url')); ?>">
      <i class="fab fa-telegram"></i> টেলিগ্রাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/withdraw/create">
      <i class="fas fa-money-bill-wave"></i> উত্তোলন 
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/helpline">
      <i class="fas fa-headset"></i> সাপোর্ট
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/raferlink">
      <i class="fas fa-user-cog"></i> রেফার করি
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/logout">
      <i class="fas fa-sign-out-alt"></i> লগ আউট
      <span class="arrow">&gt;</span>
    </a>
  </li>
</ul>
<br>
<br>
</div>

<!-- হেডার -->
<div class="header">
  <div class="header-left">
    <i class="fas fa-bars" id="menuToggle"></i>
    <span>LONG LIFE</span>
  </div>
  <div class="header-right">
    <i class="fas fa-bell"></i>
  </div>
</div>
<div class="main-box">

  <!-- বর্তমান ব্যালেন্স -->
  <div class="balance-box">
    <img src="https://cdn-icons-png.flaticon.com/128/1426/1426452.png" alt="Balance Icon" class="balance-icon" />
    <p class="balance-title">বর্তমান ব্যালেন্স</p>
    <p class="balance-amount"><?php echo e(auth()->user()->balance); ?>  টাকা</p>
  </div>


</div>
  <!-- মেনু লিস্ট -->
  <div class="menu-list">

    <a href="#" class="menu-item">
      <div class="menu-left">
        <img src="https://cdn-icons-png.flaticon.com/128/5582/5582302.png" class="menu-icon" />
        <span>ইনকাম হিস্ট্রি</span>
      </div>
      <img src="https://cdn-icons-png.flaticon.com/128/2989/2989988.png" class="arrow-icon" />
    </a>

    <a href="/withdraw/create" class="menu-item">
      <div class="menu-left">
        <img src="https://cdn-icons-png.flaticon.com/128/736/736948.png" class="menu-icon" />
        <span>ব্যালেন্স উত্তোলন করুন</span>
      </div>
      <img src="https://cdn-icons-png.flaticon.com/128/2989/2989988.png" class="arrow-icon" />
    </a>

    <a href="/withdraw" class="menu-item">
      <div class="menu-left">
        <img src="https://cdn-icons-png.flaticon.com/128/5582/5582302.png" class="menu-icon" />
        <span>ব্যালেন্স উত্তোলন হিস্ট্রি</span>
      </div>
      <img src="https://cdn-icons-png.flaticon.com/128/2989/2989988.png" class="arrow-icon" />
    </a>

    <a href="#" class="menu-item">
      <div class="menu-left">
        <img src="https://cdn-icons-png.flaticon.com/128/11294/11294721.png" class="menu-icon" />
        <span>ব্যালেন্স ট্রান্সফার করুন</span>
      </div>
      <img src="https://cdn-icons-png.flaticon.com/128/2989/2989988.png" class="arrow-icon" />
    </a>

    <a href="#" class="menu-item">
      <div class="menu-left">
        <img src="https://cdn-icons-png.flaticon.com/128/5582/5582302.png" class="menu-icon" />
        <span>ব্যালেন্স ট্রান্সফার হিস্ট্রি</span>
      </div>
      <img src="https://cdn-icons-png.flaticon.com/128/2989/2989988.png" class="arrow-icon" />
    </a>

  </div>

</div>
    
   <br>
   <br>
   <br>
   <br> 
   <br> 

<!-- ফুটার -->
<footer class="footer">
  <a href="/dashboard" class="footer-item">
    <i class="fas fa-home"></i>
    <span>হোম</span>
  </a>
  <a href="/myteam" class="footer-item">
    <i class="fas fa-users"></i>
    <span>মাই টিম</span>
  </a>
  <a href="/notice" class="footer-item">
    <i class="fas fa-coins"></i>
    <span>ইনকাম</span>
  </a>
  <a href="/helpline" class="footer-item">
    <i class="fas fa-headset"></i>
    <span>সাপোর্ট</span>
  </a>
</footer>

<!-- স্ক্রিপ্ট -->
<script>
  // সাইডবার স্টেট পরিবর্তন
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  
  // সাইডবার স্টেট চেক করে এবং সেটি টগল করা
  if (sidebar.style.left === '0px') {
    sidebar.style.left = '-260px'; // সাইডবার বন্ধ
  } else {
    sidebar.style.left = '0px'; // সাইডবার ওপেন
  }
}

// থ্রি লাইনে ক্লিক করলে সাইডবার খুলে যাবে
document.querySelector('.header-left i').addEventListener('click', toggleSidebar);
  
  // সাইডবার টগল
  document.getElementById('menuToggle').addEventListener('click', function () {
    document.getElementById('sidebar').classList.toggle('active');
  });
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  sidebar.style.left = (sidebar.style.left === '0px') ? '-260px' : '0px';
}
  

</script>

</body>
</html><?php /**PATH /home/themrsho/public_html/incomespot.the-mr.shop/resources/views/user/notice.blade.php ENDPATH**/ ?>