

<?php $__env->startSection('content-header'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Job Submits</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('AdminDash')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item active">Job Submits</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<?php
    use App\Models\JobSubmit;
    use App\Models\User;


?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Job Submission List</h3>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Job ID</th>
                            <th>Amount</th>
                            <th>Image</th>
                            <th>Status</th>
                            <th>Submitted At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $jobSubmits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($submit->id); ?></td>
                                <td>
                                    <?php
                                        $user = \App\Models\User::find($submit->user_id);
                                    ?>
                                    <?php echo e($user ? $user->name : 'N/A'); ?> (ID: <?php echo e($submit->user_id); ?>)
                                </td>
                                <td><?php echo e($submit->job_id); ?></td>
                                <td><?php echo e($submit->amount); ?> BDT</td>
                                <td>
                                    <a href="<?php echo e(asset('storage/' . $submit->job_image)); ?>" target="_blank">
                                        <img src="<?php echo e($submit->job_image); ?>" width="50">
                                    </a>
                                </td>
                                <td>
                                    <?php if($submit->status == 'Pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                    <?php elseif($submit->status == 'Approved'): ?>
                                        <span class="badge bg-success">Approved</span>
                                    <?php elseif($submit->status == 'Rejected'): ?>
                                        <span class="badge bg-danger">Rejected</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e($submit->status); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($submit->created_at->format('M d, Y h:i A')); ?></td>
                                <td>
                                    <?php if($submit->status == 'Pending'): ?>
                                    <!-- Update Status Modal Trigger -->
                                        <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#updateJobModal_<?php echo e($submit->id); ?>">Review</button>
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <!-- Modal -->
                            <div class="modal fade" id="updateJobModal_<?php echo e($submit->id); ?>" tabindex="-1" role="dialog" aria-labelledby="updateJobModalLabel_<?php echo e($submit->id); ?>" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <form method="POST" action="<?php echo e(route('AdminTasksUpdateStatus')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="job_submit_id" value="<?php echo e($submit->id); ?>">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Update Job Status</h5>
                                                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Submitted Image:</p>
                                                <img src="<?php echo e($submit->job_image); ?>" class="img-fluid mb-3">

                                                <div class="form-group">
                                                    <label for="status">Select Status</label>
                                                    <select class="form-control" name="status" required>
                                                        <option value="Approved">Approve</option>
                                                        <option value="Rejected">Reject</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button class="btn btn-success" type="submit">Update</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="d-flex justify-content-center mt-4">
    <?php echo e($jobSubmits->links('pagination::bootstrap-4')); ?>

</div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/earnjobs/public_html/resources/views/dashboard/tasks.blade.php ENDPATH**/ ?>