<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Facebook Accounts</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('AdminDash')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Facebook Accounts</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<?php
use App\Models\FBAccount;
$fbAccounts = FBAccount::latest()->get()
?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Facebook Account Management</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <table id="callRecordsTable" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th data-sortable="true">ID</th>
                            <th data-sortable="false">Facebook UID</th>
                            <th data-sortable="false">Email</th>
                            <th data-sortable="false">Password</th>
                            <th data-sortable="false">2FA Key</th>
                            <th data-sortable="false">Status</th>
                            <th data-sortable="false">Price</th>
                            <th data-sortable="true">Created At</th>
                            <th data-sortable="false">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $fbAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fbAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($fbAccount->id); ?></td>
                                <td><?php echo e($fbAccount->fb_uid); ?></td>
                                <td><?php echo e($fbAccount->fb_email); ?></td>
                                <td><?php echo e($fbAccount->fb_pass); ?></td>
                                <td><?php echo e($fbAccount->fb_2f_key ?? 'Not Available'); ?></td>
                                <td>
                                    <?php if($fbAccount->status == 'Pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                    <?php elseif($fbAccount->status == 'Approved'): ?>
                                        <span class="badge bg-success">Approved</span>
                                    <?php elseif($fbAccount->status == 'Rejected'): ?>
                                        <span class="badge bg-danger">Rejected</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e($fbAccount->status); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($fbAccount->price); ?> BDT</td>
                                <td><?php echo e($fbAccount->created_at->format('M D Y')); ?></td>
                                <td>
                                    <?php if($fbAccount->status == 'Pending'): ?>
                                        <!-- Open modal to update status -->
                                        <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#updateStatusModal_<?php echo e($fbAccount->id); ?>">Update Status</button>
                                    <?php endif; ?>
                                    <button class="btn btn-sm btn-info" onclick="copyToClipboard('<?php echo e($fbAccount->fb_uid); ?>')">Copy UID</button>
                                    <button class="btn btn-sm btn-info" onclick="copyToClipboard('<?php echo e($fbAccount->fb_email); ?>')">Copy Email</button>
                                    <button class="btn btn-sm btn-info" onclick="copyToClipboard('<?php echo e($fbAccount->fb_pass); ?>')">Copy Password</button>
                                </td>
                            </tr>

                            <!-- Modal for updating status (specific for each FB account) -->
                            <div class="modal fade" id="updateStatusModal_<?php echo e($fbAccount->id); ?>" tabindex="-1" role="dialog" aria-labelledby="updateStatusModalLabel_<?php echo e($fbAccount->id); ?>" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="updateStatusModalLabel_<?php echo e($fbAccount->id); ?>">Update Status for Facebook Account #<?php echo e($fbAccount->id); ?></h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <form action="<?php echo e(route('updateFBAccountStatus')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="fb_account_id" value="<?php echo e($fbAccount->id); ?>">
                                                <div class="form-group">
                                                    <label for="status">Select Status</label>
                                                    <select class="form-control" id="status" name="status">
                                                        <option value="Approved">Approved</option>
                                                        <option value="Rejected">Rejected</option>
                                                    </select>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Update Status</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
    // Function to copy data to clipboard
    function copyToClipboard(text) {
        const el = document.createElement('textarea');
        el.value = text;
        document.body.appendChild(el);
        el.select();
        document.execCommand('copy');
        document.body.removeChild(el);
        alert('Copied to clipboard!');
    }
</script>






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lionprof/public_html/resources/views/dashboard/fb.blade.php ENDPATH**/ ?>