<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\user\dashController;
use App\Http\Controllers\user\indexController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [indexController::class, 'index'])->name('index');
Route::get('/catalog', [indexController::class, 'catalog'])->name('catalog');
Route::get('/cron', [dashController::class, 'cronJob'])->name('cronJob');



Route::get('/cron/salary', [AdminController::class, 'processLeaderSalaries'])->name('processLeaderSalaries');

Route::group(['middleware' => 'guest'], function () {

    // Get Requests
    Route::get('/login', [indexController::class, 'login'])->name('login');
    Route::get('/register', [indexController::class, 'register'])->name('register');

    // Post Requests
    Route::post('/login-submit', [indexController::class, 'login_submit'])->name('login_submit');
    Route::post('/register-submit', [indexController::class, 'register_submit'])->name('register_submit');

    // Admin
    Route::get('/login/admin', [AdminController::class, 'getLogin'])->name('getLogin');
    Route::post('/login/admin', [AdminController::class, 'postLogin'])->name('postLogin');

});

Route::group(['middleware' => 'auth'], function () {

    // Get Requests
    Route::get('/dashboard', [dashController::class, 'dashboard'])->name('dashboard');
    Route::get('/fb_sell', [dashController::class, 'fb_sell'])->name('fb.sell');
    Route::get('/gmail_sell', [dashController::class, 'gmail_sell'])->name('gmail.sell');
     Route::post('/gmail_store', [dashController::class, 'gmail_store'])->name('gmail_account.store');
    Route::get('/gmail_sell/history', [dashController::class, 'gmail_history'])->name('gmail.sell.history');
    Route::get('/fb_sell/history', [dashController::class, 'fb_history'])->name('fb.sell.history');
    Route::post('/fb_store', [dashController::class, 'fb_store'])->name('fb_account.store');
    Route::get('/profile', [dashController::class, 'profile'])->name('profile');
    Route::get('/jobs', [dashController::class, 'jobs'])->name('jobs');
    Route::get('/mdsell', [dashController::class, 'mdsell'])->name('mdsell');
    Route::get('/ledgers', [dashController::class, 'ledgers'])->name('ledgers');
    Route::get('/ticket', [dashController::class, 'ticket'])->name('ticket');
    Route::get('/transfer', [dashController::class, 'transfer'])->name('transfer');

    Route::get('/myteam', [dashController::class, 'myteam'])->name('myteam');
    Route::get('/myteam/first', [dashController::class, 'first_refer'])->name('first_refer');
    Route::get('/myteam/second', [dashController::class, 'second_refer'])->name('second_refer');
    Route::get('/myteam/third', [dashController::class, 'third_refer'])->name('third_refer');
    Route::get('/myteam/fourth', [dashController::class, 'fourth_refer'])->name('fourth_refer');

    Route::get('/my-jobs', [dashController::class, 'Myjobs'])->name('Myjobs');

    Route::get('/salary', [dashController::class, 'salary'])->name('salary');
    Route::get('/month', [dashController::class, 'month'])->name('month');
    Route::get('/raferlink', [dashController::class,'raferlink'])->name('raferlink');
    Route::get('/leaderbaord', [dashController::class, 'leaderbaord'])->name('leaderbaord');
    

    Route::get('/helpline', [dashController::class, 'helpline'])->name('helpline');
    Route::get('/notice', [dashController::class, 'notice'])->name('notice');



    Route::get('/withdraw', [dashController::class, 'withdraw'])->name('withdraw');
    Route::get('/withdraw/create', [dashController::class, 'withdrawCreate'])->name('withdrawCreate');

    Route::get('/payment', [dashController::class, 'payment'])->name('payment');

    Route::get('/account/payment', [dashController::class, 'account_payment'])->name('account_payment');
    Route::get('/account/payment/{status}', [dashController::class, 'account_payment_status'])->name('account_payment_status');

    Route::get('/logout', [dashController::class, 'logout'])->name('logout');

    // Post Requests
    Route::post('/withdraw/create-submit', [dashController::class, 'withdrawCreate_submit'])->name('withdrawCreate_submit');
    Route::post('/profile/update', [dashController::class, 'profile_update'])->name('profile_update');
    Route::post('/task/submit/{job_id}', [dashController::class, 'task_submit'])->name('task_submit');

});

Route::group(['middleware' => 'admin'], function () {
    Route::get('/admin/action/users/active/{id}', [AdminController::class, 'ActiveUser'])->name('ActiveUser');
    Route::get('/admin/action/users/deactive/{id}', [AdminController::class, 'DectiveUser'])->name('DectiveUser');
    
    Route::get('/admin/action/withdraw/paid/{id}', [AdminController::class, 'WithdrawPaid'])->name('WithdrawPaid');
    Route::get('/admin/action/withdraw/failed/{id}', [AdminController::class, 'WithdrawFailed'])->name('WithdrawFailed');
    Route::get('/admin/notice/delete/{id}', [AdminController::class, 'NoticeAdminDelete'])->name('NoticeAdminDelete');
    Route::post('/admin/notice-submit', [AdminController::class, 'submitNotice'])->name('submitNotice');

Route::get('/admin/tasks', [AdminController::class, 'AdminTasks'])->name('AdminTasks');
Route::post('/admin/tasks', [AdminController::class, 'AdminTasksUpdateStatus'])->name('AdminTasksUpdateStatus');

Route::get('/admin/leaders', [AdminController::class, 'AdminLeaders'])->name('AdminLeaders');
Route::post('/admin/leaders', [AdminController::class, 'AdminLeadersAddOrUpdate'])->name('AdminLeadersAdd');
Route::delete('/admin/leaders/{id}', [AdminController::class, 'AdminLeadersDelete'])->name('AdminLeadersDelete');



Route::get('/admin/DeactivateAllAccounts', [AdminController::class, 'DeactivateAllAccounts'])->name('DeactivateAllAccounts');
Route::get('/admin/ActivateAllAccounts', [AdminController::class, 'ActivateAllAccounts'])->name('ActivateAllAccounts');

    Route::get('/admin/faceook', [AdminController::class, 'AdminFacebook'])->name('AdminFacebook');
    Route::post('/admin/faceook', [AdminController::class, 'updateFBAccountStatus'])->name('updateFBAccountStatus');
    
    Route::get('/admin/gmail', [AdminController::class, 'AdminGmail'])->name('AdminGmail');
    Route::post('/admin/gmail', [AdminController::class, 'updateGmailAccountStatus'])->name('updateGmailAccountStatus');
        
    Route::get('/admin/dash', [AdminController::class, 'AdminDash'])->name('AdminDash');
    Route::get('/admin/task-setting', [AdminController::class, 'taskSettings'])->name('taskSettings');
    Route::post('/admin/task-setting-submit', [AdminController::class, 'taskSettingsPost'])->name('taskSettingsPost');
    Route::get('/admin/notice', [AdminController::class, 'NoticeAdmin'])->name('NoticeAdmin');
    Route::get('/admin/users/active', [AdminController::class, 'ActiveUsers'])->name('ActiveUsers');
    Route::get('/admin/users/inactive', [AdminController::class, 'InActiveUsers'])->name('InActiveUsers');
    Route::get('/admin/users/payments', [AdminController::class, 'AdminPayments'])->name('AdminPayments');
    Route::get('/admin/users/withdraws', [AdminController::class, 'AdminWithdraws'])->name('AdminWithdraws');
    Route::get('/admin/system-settings', [AdminController::class, 'systemSettings'])->name('systemSettings');
    Route::post('/admin/system-settings-submit', [AdminController::class, 'systemSettingsPost'])->name('systemSettingsPost');
    Route::get('/admin/change-password', [AdminController::class, 'changepwd'])->name('changepwd');
    Route::post('/admin/change-password-submit', [AdminController::class, 'changepwdPost'])->name('changepwdPost');
});
