
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>LONG LIFE ড্যাশবোর্ড</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

  <style>
    body {
      font-family: 'Arial', sans-serif;
      background: #AFEEEE;
      margin: 0;
      padding: 0;
    }

    /* হেডার */
    .header {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      padding: 15px 20px 60px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: white;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
      border-bottom-left-radius: 80px 30px;
      border-bottom-right-radius: 80px 30px;
      position: relative;
      z-index: 1001;
    }
    .header-left {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .header-left i, .header-right i {
      font-size: 26px;
      cursor: pointer;
    }
    .header-left span {
      font-size: 22px;
      font-weight: bold;
    }
    
    /* সাইডবার */
.sidebar {
  position: fixed;
  top: 0;
  left: -260px;
  height: 100%;
  width: 260px;
  background: linear-gradient(180deg, #43a047, #2e7d32);
  transition: all 0.3s ease;
  z-index: 9999;
  overflow-y: auto;
  padding-top: 20px;
  box-shadow: 2px 0 8px rgba(0, 0, 0, 0.2);
}

/* সাইডবার লিঙ্ক */
.sidebar a {
  display: flex;
  align-items: center;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  color: white;
  text-decoration: none;
  font-size: 18px;
  transition: background 0.3s ease;
  margin: 0;
  line-height: 1;
}

.sidebar a i {
  margin-right: 10px;
}

.sidebar a:hover {
  background: #16a085;
}

.sidebar a .link-text {
  flex-grow: 1;
  margin-left: 10px;
  text-align: left;
}

.sidebar a .arrow {
  margin-left: auto;
}

/* সাইডবার হেডার */
.sidebar-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px 15px; /* হেডারের প্যাডিং কমানো হলো */
  background: linear-gradient(90deg, #4CAF50, #2ecc71);
}

.sidebar-header h2 {
  color: white;
  font-size: 20px;
  margin: 0;
}

/* সাইডবার ক্লোজ বাটন */
.sidebar .close-btn {
  font-size: 30px;
  color: white;
  cursor: pointer;
}

/* সাইডবার লিঙ্কের তালিকা */
.sidebar-links {
  list-style: none;
  padding: 0;
  margin: 0;
}

.sidebar-links li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  border-bottom: 1px solid #fff; /* সাদা দাগ */
}

.sidebar-links li a {
  display: flex;
  align-items: center;
  color: white;
  text-decoration: none;
  font-size: 16px;
  flex-grow: 1;
}

.sidebar-links li a i {
  margin-right: 8px;
  font-size: 18px;
}

/* রেসপন্সিভ */
@media (max-width: 768px) {
  .sidebar {
    width: 230px;
  }
}
.sidebar-user-info {
  padding: 20px 10px;
  border-bottom: 1px solid #ffffff;
  text-align: center;
}

.sidebar-user-info .profile-pic img {
  height: 80px;
  width: 80px;
  object-fit: cover;
  border-radius: 50%;
  border: 2px solid white;
  margin-bottom: 10px;
}

.sidebar-user-info .decorative-line {
  height: 20px;
  margin: 0 auto 10px;
  display: block;
}

.sidebar-user-info .user-name {
  margin: 5px 0;
  font-size: 18px;
  color: #ffffff;
  font-weight: bold;
}

.sidebar-user-info .user-data {
  margin-top: 8px;
  color: #ffffff;
  font-size: 14px;
}

.sidebar-user-info .user-data p {
  margin: 4px 0;
}

.sidebar-user-info .account-status {
  margin-top: 8px;
  padding: 6px 20px;
  background: linear-gradient(135deg, #6a11cb, #2575fc);
  border-radius: 20px;
  display: inline-block;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  font-weight: bold;
}


.user-info {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-top: 20px;
}

.user-info img {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  border: 3px solid #ffffff;
  object-fit: cover; /* ইমেজকে সুন্দরভাবে কাটবে */
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* হালকা ছায়া */
}

.user-info h3 {
  margin: 10px 0 5px;
  font-size: 20px;
  color: #ffffff;
  font-weight: 600;
}

.user-info p {
  font-size: 14px;
  color: #ecf0f1;
  margin: 2px 0;
}
    
    
    
    
    
    
    

    

    /* প্রজেক্ট সেকশন */
    h2 {
      text-align: center;
      margin: 20px 0 10px;
      font-size: 24px;
      color: #333;
    }
    .project-wrapper {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
      gap: 12px;
      max-width: 800px;
      margin: 10px auto;
      padding: 0 15px;
    }
    .project-box {
      background: #fff;
      height: 110px;
      border-radius: 15px;
      box-shadow: 0 3px 8px rgba(0,0,0,0.1);
      text-align: center;
      padding: 10px 5px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-decoration: none;
      color: #333;
      transition: all 0.3s ease;
    }
    .project-box:hover {
      background: #e0f7fa;
      transform: translateY(-5px);
    }
    .project-box i {
      font-size: 28px;
      margin-bottom: 5px;
    }
    .project-text {
      font-size: 14px;
      font-weight: bold;
    }

    /* ফুটার */
    .footer {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      display: flex;
      justify-content: space-around;
      align-items: center;
      padding: 10px 0;
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      z-index: 999;
      height: 65px;
      box-shadow: 0 -2px 8px rgba(0,0,0,0.1);
    }
    .footer-item {
      color: white;
      text-decoration: none;
      font-size: 13px;
      display: flex;
      flex-direction: column;
      align-items: center;
      flex: 1;
      position: relative;
    }
    .footer-item i {
      font-size: 22px;
      margin-bottom: 3px;
    }
    .footer-item:not(:last-child)::after {
      content: "";
      position: absolute;
      right: 0;
      top: 10px;
      bottom: 10px;
      width: 1px;
      background: rgba(255,255,255,0.5);
    }

    /* মোবাইল রেসপন্সিভ */
    @media (max-width: 768px) {
      .project-box { height: 100px; }
      .project-box i { font-size: 24px; }
      .project-text { font-size: 12px; }
    }
    @media (max-width: 480px) {
      .project-wrapper { grid-template-columns: repeat(3, 1fr); }
      .project-box { height: 90px; }
      .project-box i { font-size: 22px; }
      .project-text { font-size: 11px; }
    }

/* পপআপ নোটিশ */
    .popup-overlay {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.5);
      display: none;
      justify-content: center;
      align-items: center;
      z-index: 9999;
    }
    .popup-content {
      background: #fff;
      padding: 20px;
      border-radius: 15px;
      width: 80%;
      max-width: 320px;
      text-align: center;
      position: relative;
      box-shadow: 0 8px 20px rgba(0,0,0,0.2);
      animation: popup-appear 0.5s ease;
    }
    .popup-content img {
      width: 100%;
      height: auto;
      border-radius: 10px;
      margin-bottom: 15px;
    }
    .popup-content h3 {
      font-size: 20px;
      color: #2ecc71;
      margin: 10px 0 8px;
    }
    .popup-content p {
      font-size: 16px;
      color: #555;
    }
    .close-btn {
      position: absolute;
      top: 10px;
      right: 10px;
      background: #ff4d4d;
      color: white;
      border: none;
      border-radius: 50%;
      width: 30px; height: 30px;
      font-size: 20px;
      cursor: pointer;
      transition: 0.3s;
    }
    .close-btn:hover { background: #e60000; }

    @keyframes popup-appear {
      from { transform: scale(0.7); opacity: 0; }
      to { transform: scale(1); opacity: 1; }
    }



</style>

</head>

<body>

<!-- পপআপ নোটিশ -->
<div class="popup-overlay" id="popupNotice">
  <div class="popup-content">
    <button class="close-btn" onclick="closePopup()">×</button>
    <img src="https://i.ibb.co/C3B8gRsC/author-4.jpg" alt="Notice Banner">
    <h3>জরুরী নোটিশ</h3>
    <p>আজ বিকাল ৩টায় আমাদের অফিসিয়াল টেলিগ্রাম গ্রুপে জরুরী মিটিং হবে। সকলে উপস্থিত থাকবেন।</p>
  </div>
</div>

<!-- সাইডবারের কোড -->
<div class="sidebar" id="sidebar">
  <div class="sidebar-header">
    <h2>মেনু</h2>
    <button class="close-sidebar" onclick="toggleSidebar()">×</button>
  </div>
 
 
<div class="sidebar-user-info text-center">
    <div class="profile-pic">
        <img src="{{ asset('uploads/profile_images/' . Auth::user()->profile_image) }}" alt="User">
    </div>
    
    
    <h5 class="user-name">{{auth()->user()->fname}} {{auth()->user()->lname}}</h5>
    
    <div class="user-data">
        <p class="m-0">Refer ID: {{ auth()->user()->ref_code }}</p>
        <p class="m-0">Joined: {{ auth()->user()->created_at->format('M D Y') }}</p>
        
        <div class="account-status">
            একাউন্ট সেটিংস : 
            <span style="color: #ff4d4d">
                🎉
            </span>
        </div>
    </div>
</div>
    
  <ul class="sidebar-links">
  <li>
    <a href="/dashboard">
      <i class="fas fa-home"></i> হোম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/profile">
      <i class="fas fa-user"></i> প্রোফাইল
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/notice">
      <i class="fas fa-coins""></i>আমার ইনকাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="{{ app('telegram_url') }}">
      <i class="fab fa-telegram"></i> টেলিগ্রাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/withdraw/create">
      <i class="fas fa-money-bill-wave"></i> উত্তোলন 
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/helpline">
      <i class="fas fa-headset"></i> সাপোর্ট
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/raferlink">
      <i class="fas fa-user-cog"></i> রেফার করি
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
  
    <a href="/logout">
      <i class="fas fa-sign-out-alt"></i> লগ আউট
      <span class="arrow">&gt;</span>
    </a>
  </li>
</ul>
<br>
<br>
</div>
<!-- হেডার -->
<div class="header">
  <div class="header-left">
    <i class="fas fa-bars" id="menuToggle"></i>
    <span>LONG LIFE</span>
  </div>
  <div class="header-right">
    <i class="fas fa-bell"></i>
  </div>
</div>
</div>
            </div>
<div class="col-lg-8">
    <div class="padding-top-2x mt-2 d-block d-lg-none"></div>
    <div class="row u-d-d">
        @if(auth()->user()->user_active == 0)
            <div class="col-md-12">
                <div style="background-color: #d4edda; border: 1px solid #28a745; border-radius: 10px; padding: 20px; margin: 20px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
                    <p class="text-center bangla-font" style="color: #155724; font-weight: bold; font-size: 16px;">
                        আপনার একাউন্টটি একটিভ নয়। একটিভ করুন ধন্যবাদ।<br><br>
                        <a class="btn" href="{{ route('account_payment') }}" style="background-color: #28a745; color: white; padding: 10px 20px; border-radius: 5px; text-decoration: none;">
                            Active Now
                        </a>
                    </p>
                </div>
            </div>
        @endif
    </div>
</div>

<!-- প্রজেক্ট লিস্ট -->
<h2>আমাদের প্রজেক্ট সমূহ</h2>
<div class="project-wrapper">

  <a href="/catalog" class="project-box">
    <i class="fas fa-sim-card" style="color: #e67e22;"></i>
    <div class="project-text">মোবাইল রিচার্জ</div>
  </a>

  <a href="{{ route('salary') }}" class="project-box">
    <i class="fas fa-network-wired" style="color: #6c5ce7;"></i>
    <div class="project-text">ড্রাইভ অফার</div>
  </a>

  <a href="/raferlink" class="project-box">
    <i class="fas fa-users" style="color: #00cec9;"></i>
    <div class="project-text">রেফার করি</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fas fa-gem" style="color: #9b59b6;"></i>
    <div class="project-text">প্রিমিয়াম সার্ভিস</div>
  </a>

  <a href="/gmail_sell" class="project-box">
    <i class="fas fa-envelope-open-text" style="color: #e84393;"></i>
    <div class="project-text">জিমেইল সেল</div>
  </a>

  <a href="/fb_sell" class="project-box">
    <i class="fab fa-facebook" style="color: #3498db;"></i>
    <div class="project-text">ফেসবুক সেল</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fab fa-instagram" style="color: #fd79a8;"></i>
    <div class="project-text">ইনস্টাগ্রাম সেল</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fab fa-telegram-plane" style="color: #00b894;"></i>
    <div class="project-text">টেলিগ্রাম সেল</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fab fa-whatsapp" style="color: #25D366;"></i>
    <div class="project-text">হোয়াটসঅ্যাপ সেল</div>
  </a>

  <a href="/jobs" class="project-box">
    <i class="fas fa-briefcase" style="color: #1abc9c;"></i>
    <div class="project-text">মাইক্রো টাস্ক</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fas fa-hands-helping" style="color: #6c5ce7;"></i>
    <div class="project-text">সোশ্যাল সার্ভিস</div>
  </a>

  <a href="/leaderbaord" class="project-box">
    <i class="fas fa-trophy" style="color: #e67e22;"></i>
    <div class="project-text">লিডারবোর্ড</div>
  </a>

  <a href="/month" class="project-box">
    <i class="fas fa-crosshairs" style="color: #d63031;"></i>
    <div class="project-text">টার্গেট বোনাস</div>
  </a>

  <a href="/month" class="project-box">
    <i class="fas fa-wallet" style="color: #27ae60;"></i>
    <div class="project-text">মাসিক বেতন</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fas fa-globe" style="color: #9b59b6;"></i>
    <div class="project-text">ওয়েবসাইট জিতুন</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fas fa-server" style="color: #00cec9;"></i>
    <div class="project-text">ডোমেইন হোস্টিং</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fas fa-tint" style="color: #e84393;"></i>
    <div class="project-text">ব্লাড ব্যাংক</div>
  </a>

  <a href="/catalog" class="project-box">
    <i class="fas fa-hand-holding-heart" style="color: #e74c3c;"></i>
    <div class="project-text">ডোনেশন</div>
  </a>

</div>
<br>
<br>
<br>
<br>
<br>
</div>

<!-- ফুটার -->
<footer class="footer">
  <a href="/dashboard" class="footer-item">
    <i class="fas fa-home"></i>
    <span>হোম</span>
  </a>
  <a href="/myteam" class="footer-item">
    <i class="fas fa-users"></i>
    <span>মাই টিম</span>
  </a>
  <a href="/notice" class="footer-item">
    <i class="fas fa-coins"></i>
    <span>ইনকাম</span>
  </a>
  <a href="/helpline" class="footer-item">
    <i class="fas fa-headset"></i>
    <span>সাপোর্ট</span>
  </a>
</footer>

<!-- স্ক্রিপ্ট -->
<script>
  // সাইডবার স্টেট পরিবর্তন
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  
  // সাইডবার স্টেট চেক করে এবং সেটি টগল করা
  if (sidebar.style.left === '0px') {
    sidebar.style.left = '-260px'; // সাইডবার বন্ধ
  } else {
    sidebar.style.left = '0px'; // সাইডবার ওপেন
  }
}

// থ্রি লাইনে ক্লিক করলে সাইডবার খুলে যাবে
document.querySelector('.header-left i').addEventListener('click', toggleSidebar);
  
  // সাইডবার টগল
  document.getElementById('menuToggle').addEventListener('click', function () {
    document.getElementById('sidebar').classList.toggle('active');
  });
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  sidebar.style.left = (sidebar.style.left === '0px') ? '-260px' : '0px';
}
  

document.addEventListener('DOMContentLoaded', function () {
    if (!sessionStorage.getItem('noticeShown')) {
      document.getElementById('popupNotice').style.display = 'flex';
      sessionStorage.setItem('noticeShown', 'true');
    }
  });

  function closePopup() {
    document.getElementById('popupNotice').style.display = 'none';
  }

  document.querySelector('.header-right i').addEventListener('click', function() {
    document.getElementById('popupNotice').style.display = 'flex';
  });

</script>

</body>
</html>
                        </a>
    
<style>
   .image .profile-pic {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 50%;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.4);
}
.image {
    position: relative;
    height: 120px;
    margin: auto;
    width: 120px;
    box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
    border-radius: 78px;
}
        .profile-card {
            max-width: 100%;
            margin: 20px auto;
            padding: 20px;
            background-color: #f8f9fa;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .profile-card img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            object-fit: cover;
        }
        .profile-card .info {
            margin-top: 15px;
        }
        .profile-card .info p {
            margin: 0;
        }
        .profile-card .info .address,
        .profile-card .info .mobile {
            font-size: 0.9rem;
            color: #6c757d;
            display: flex;
            justify-content: space-between;
        }
        .profile-card p{
          margin: 0px;
        }
    </style>
            <style>
        .color-changing-text {
        font-size: 1rem;
    animation: colorChange 9s infinite; 
}



</style>
                </div>
            </div>
        </div>
    </div>

    <script>
        function copyRefLink(text){
            const body = document.body;
            const input = document.createElement("input");
            body.append(input);
            input.style.opacity = 0;
            input.value = text.replaceAll(' ', '');
            input.select();
            input.setSelectionRange(0, input.value.length);
            document.execCommand("Copy");
            input.blur();
            input.remove();
            alert('Refer copied.')
        }
    </script>

    <script>
        function copyACNumber(text){
            const body = document.body;
            const input = document.createElement("input");
            body.append(input);
            input.style.opacity = 0;
            input.value = text.replaceAll(' ', '');
            input.select();
            input.setSelectionRange(0, input.value.length);
            document.execCommand("Copy");
            input.blur();
            input.remove();
            alert('Account number copied.')
        }
    </script>

<!--    announcement banner section start   -->
<a class="announcement-banner" href="#announcement-modal"></a>
<div id="announcement-modal" class="mfp-hide white-popup">
    <a href="#">
        <img src="/user/assets/images/1638791990Untitled-1.jpg" alt="">
    </a>
</div>
<!--    announcement banner section end   -->


<!-- Back To Top Button-->
<a class="scroll-to-top-btn" href="#">
    <i class="icon-chevron-up"></i>
</a>
<!-- Backdrop-->
<div class="site-backdrop"></div>

<!-- Cookie alert dialog  -->

<!-- Cookie alert dialog  -->

<script>
    var mainbs = {"is_announcement":0,"announcement_delay":"1.00","overlay":null};
    var decimal_separator = '.';
    var thousand_separator = ',';
</script>

<!-- JavaScript (jQuery) libraries, plugins and custom scripts-->
<script type="text/javascript" src="/user/assets/front/js/plugins.min.js"></script>
<script type="text/javascript"
        src="/user/assets/back/js/plugin/bootstrap-notify/bootstrap-notify.min.js"></script>
<script type="text/javascript" src="/user/assets/front/js/scripts.min.js"></script>
<script type="text/javascript" src="/user/assets/front/js/lazy.min.js"></script>
<script type="text/javascript" src="/user/assets/front/js/lazy.plugin.js"></script>
<script type="text/javascript" src="/user/assets/front/js/myscript.js"></script>

<!-- off inspact-->


<script type="text/javascript">
    let mainurl = 'https://promote100next.com';

    let view_extra_index = 0;

    // Notifications
    function SuccessNotification(title) {
        $.notify({
            title: ` <strong>${title}</strong>`,
            message: '',
            icon: 'fas fa-check-circle'
        }, {
            element: 'body',
            position: null,
            type: "success",
            allow_dismiss: true,
            newest_on_top: false,
            showProgressbar: false,
            placement: {
                from: "top",
                align: "right"
            },
            offset: 20,
            spacing: 10,
            z_index: 1031,
            delay: 5000,
            timer: 1000,
            url_target: '_blank',
            mouse_over: null,
            animate: {
                enter: 'animated fadeInDown',
                exit: 'animated fadeOutUp'
            },
            onShow: null,
            onShown: null,
            onClose: null,
            onClosed: null,
            icon_type: 'class'
        });
    }

    function DangerNotification(title) {
        $.notify({
            // options
            title: ` <strong>${title}</strong>`,
            message: '',
            icon: 'fas fa-exclamation-triangle'
        }, {
            // settings
            element: 'body',
            position: null,
            type: "danger",
            allow_dismiss: true,
            newest_on_top: false,
            showProgressbar: false,
            placement: {
                from: "top",
                align: "right"
            },
            offset: 20,
            spacing: 10,
            z_index: 1031,
            delay: 5000,
            timer: 1000,
            url_target: '_blank',
            mouse_over: null,
            animate: {
                enter: 'animated fadeInDown',
                exit: 'animated fadeOutUp'
            },
            onShow: null,
            onShown: null,
            onClose: null,
            onClosed: null,
            icon_type: 'class'
        });
    }

    // Notifications Ends
</script>


<script>
    
    
    </script>

</body>
</html>
<style>
    .alert-success h5{
        margin:0px;
    }
    .alert-success {
    background-color: #fff;
        border-radius: 12px;
        box-shadow: rgba(0, 0, 0, 0.35) 1px 5px 7px;
}
.alert::before {
    border: none;
}
strong {
    font-weight: 500;
    font-family: inherit;
}

@media (max-width: 991px) {
    .page-title {
        margin-bottom: 16px;
    }
}

.kjsadhfk h5{
    color:#fff !important;
}
.top_all_im {
    height: 45px !important;
    border-radius: 50px;
    border: 3px solid red;
}
        .item {
            text-align: center;
            border: 1px solid #ddd;
            padding: 10px;
            border-radius: 8px;
            background-color: #f8f9fa;
        }
        .item img {
            width: 100%;
            max-height: 150px;
            object-fit: cover;
            border-radius: 5px;
        }
        .item h5 {
            margin-top: 10px;
                font-size: 15px;
    margin-bottom:0;
    font-family: 'SolaimanLipi', 'Nikosh', 'Kalpurush', 'Bangla', sans-serif;
        }
    .sharebtn {
        font-size: 12px;
    }

    .sharebtn i {
        width: 25px;
        height: 25px;
        line-height: 25px;
        font-size: 18px;
    }
    .refferal_code_s{
        background: #fff;
        border-radius: 10px;
        padding-left: 12px;
    }
    .sadfasdf{
        border-radius: 7px;
        background: #0067ff !important;
    }
    .dsafasdf{
            background: #4b89fb !important;
    }
    }
    .alert {
        border: none;
    }
    .sdfasdfds strong{
        text-align:center;
        font-size:12px;
    }
                                
</style>

    <script language="JavaScript">
      
       window.onload = function () {
           document.addEventListener("contextmenu", function (e) {
               e.preventDefault();
           }, false);
           document.addEventListener("keydown", function (e) {
               if (e.ctrlKey && e.shiftKey && e.keyCode == 73) {
                   disabledEvent(e);
               }
               if (e.ctrlKey && e.shiftKey && e.keyCode == 74) {
                   disabledEvent(e);
               }
               if (e.keyCode == 83 && (navigator.platform.match("Mac") ? e.metaKey : e.ctrlKey)) {
                   disabledEvent(e);
               }
               if (e.ctrlKey && e.keyCode == 85) {
                   disabledEvent(e);
               }
               if (event.keyCode == 123) {
                   disabledEvent(e);
               }
           }, false);
           function disabledEvent(e) {
               if (e.stopPropagation) {
                   e.stopPropagation();
               } else if (window.event) {
                   window.event.cancelBubble = true;
               }
               e.preventDefault();
               return false;
           }
       }
</script> 

