@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Payments</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('AdminDash')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Payments</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')


            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="callRecordsTable" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th data-sortable="true">ID</th>
                                    <th data-sortable="true">Date</th>
                                    <th data-sortable="false">Method</th>
                                    <th data-sortable="false">Number</th>
                                    <th data-sortable="false">Transaction ID</th>
                                    <th data-sortable="false">Amount</th>
                                    <th data-sortable="true">Status</th>
                                </tr>
                                </thead>
                                @foreach($data as $item)
                                    <tr class="text-center">
                                        {{--                                        <td colspan="7">Record Not Found!</td>--}}
                                        <td>{{ $item->id }}</td>
                                        <td>{{ \Carbon\Carbon::parse($item->created_at)->format('d.m.Y') }}</td>
                                        <td>{{ $item->method }}</td>
                                        <td>{{ $item->number }}</td>
                                        <td>{{ $item->trxid }}</td>
                                        <td>{{ $item->amount }}</td>
                                        <td>
                                            @if($item->status == "Success")
                                                <span class="badge badge-success">Success</span>
                                            @elseif($item->status == "Pending")
                                                <span class="badge badge-warning">Pending</span>
                                            @else
                                                <span class="badge badge-danger">Failed</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>


@endsection
