@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">WhatsApp Accounts</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('AdminDash')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">WhatsApp Accounts</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')
@php
use App\Models\Gmail;
$fbAccounts = Gmail::latest()->get()
@endphp
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">WhatsApp Account Management</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <table id="emailAccounts" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th data-sortable="true">ID</th>
                            <th data-sortable="false">WhatsApp</th>
                            <th data-sortable="false">Password</th>
                            <th data-sortable="false">brekap Gmail</th>
                            <th data-sortable="false">WhatsApp otp</th>
                            <th data-sortable="false">Status</th>
                            <th data-sortable="false">Price</th>
                            <th data-sortable="true">Created At</th>
                            <th data-sortable="false">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($fbAccounts as $fbAccount)
                            <tr>
                                <td>{{ $fbAccount->id }}</td>
                                <td>{{ $fbAccount->gmail }}</td>
                                <td>{{ $fbAccount->password }}</td>
                                <td>{{ $fbAccount->re_gmail }}</td>
                                <td>{{ $fbAccount->backup ?? 'Not Available' }}</td>
                                <td>
                                    @if($fbAccount->status == 'Pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @elseif($fbAccount->status == 'Approved')
                                        <span class="badge bg-success">Approved</span>
                                    @elseif($fbAccount->status == 'Rejected')
                                        <span class="badge bg-danger">Rejected</span>
                                    @else
                                        <span class="badge bg-secondary">{{$fbAccount->status}}</span>
                                    @endif
                                </td>
                                <td>{{ $fbAccount->price }} BDT</td>
                                <td>{{ $fbAccount->created_at->format('M D Y') }}</td>
                                <td>
                                    @if($fbAccount->status == 'Pending')
                                        <!-- Open modal to update status -->
                                        <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#updateStatusModal_{{ $fbAccount->id }}">Update Status</button>
                                    @endif
                                    <button class="btn btn-sm btn-info m-1" onclick="copyToClipboard('{{ $fbAccount->gmail }}')">Copy Gmail</button>
                                    <button class="btn btn-sm btn-info m-1 " onclick="copyToClipboard('{{ $fbAccount->password }}')">Copy Password</button>
                                    <button class="btn btn-sm btn-info m-1" onclick="copyToClipboard('{{ $fbAccount->re_gmail }}')">Copy Recovery Gmail</button>
                                </td>
                            </tr>

                            <!-- Modal for updating status (specific for each FB account) -->
                            <div class="modal fade" id="updateStatusModal_{{ $fbAccount->id }}" tabindex="-1" role="dialog" aria-labelledby="updateStatusModalLabel_{{ $fbAccount->id }}" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="updateStatusModalLabel_{{ $fbAccount->id }}">Update Status for Facebook Account #{{ $fbAccount->id }}</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <form action="{{ route('updateGmailAccountStatus') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="fb_account_id" value="{{ $fbAccount->id }}">
                                                <div class="form-group">
                                                    <label for="status">Select Status</label>
                                                    <select class="form-control" id="status" name="status">
                                                        <option value="Approved">Approved</option>
                                                        <option value="Rejected">Rejected</option>
                                                    </select>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Update Status</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>


<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script>
    // Function to copy data to clipboard
    function copyToClipboard(text) {
        const el = document.createElement('textarea');
        el.value = text;
        document.body.appendChild(el);
        el.select();
        document.execCommand('copy');
        document.body.removeChild(el);
        alert('Copied to clipboard!');
    }
    
    $(document).ready(function() {
        $('#emailAccounts').DataTable({
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    text: 'Export to Excel',
                    title: 'Data Export'
                }
            ]
        });
    });
</script>







@endsection
